<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\CommandBus\ExecutePayment;

use IssetBV\PaymentBundle\Domain\Identifier\LocalPaymentIdentifier;
use IssetBV\TalosBundle\Gateway\Request\ClientData;
use League\Uri\Schemes\Http;
use PhpOption\Option;

/**
 * Class CreatePaymentCommand.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
final class ExecutePaymentCommand
{
    /**
     * @var ClientData|null
     */
    private $clientData;

    /**
     * @var LocalPaymentIdentifier
     */
    private $paymentId;

    /**
     * @var string|null
     */
    private $returnUrl;

    /**
     * CreatePaymentCommand constructor.
     *
     * @param LocalPaymentIdentifier $paymentId
     * @param string|null $returnUrl
     * @param ClientData|null $clientData
     */
    public function __construct(LocalPaymentIdentifier $paymentId, string $returnUrl = null, ClientData $clientData = null)
    {
        $this->paymentId = $paymentId;
        $this->clientData = $clientData;

        if ($returnUrl) {
            Http::createFromString($returnUrl); // @throws
        }

        $this->returnUrl = $returnUrl;
    }

    public function getPaymentId(): LocalPaymentIdentifier
    {
        return $this->paymentId;
    }

    public function getReturnUrl(): Option
    {
        return Option::fromValue($this->returnUrl);
    }

    public function getClientData(): Option
    {
        return Option::fromValue($this->clientData);
    }
}
