<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\OpenSSL;

/**
 * Class OpenSSLThing.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
abstract class OpenSSLThing
{
    const FINGERPRINT_SHA1 = 'sha1';
    const FINGERPRINT_MD5 = 'md5';

    /**
     * @var string
     */
    private $data;

    /**
     * OpenSSLThing constructor.
     *
     * @param string $data
     */
    protected function __construct($data)
    {
        $this->data = $data;
    }

    /**
     * @param string $hashAlgorithm must be self::FINGERPRINT_SHA1 or self::FINGERPRINT_MD5
     *
     * @return string
     */
    public function getFingerprint($hashAlgorithm = self::FINGERPRINT_SHA1)
    {
        return openssl_x509_fingerprint($this->getData(), $hashAlgorithm);
    }

    /**
     * @return string
     */
    public function getData(): string
    {
        return $this->data;
    }
}
