<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Repository;

use Doctrine\ORM\EntityRepository;
use IssetBV\PaymentBundle\Domain\Repository\WalletTypeRepository;
use PhpOption\Option;

/**
 * Class DoctrineWalletTypeRepository.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
class DoctrineWalletTypeRepository extends EntityRepository implements WalletTypeRepository
{
    /**
     * @param string $identifier
     *
     * @return Option<WalletType>
     */
    public function optionallyFind(string $identifier): Option
    {
        return Option::ensure($this->find($identifier));
    }
}
