<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\Form\DataTransformer;

use IssetBV\PaymentBundle\Entity\Interval;
use Symfony\Component\Form\DataTransformerInterface;
use Symfony\Component\Form\Exception\TransformationFailedException;

/**
 * @author Tim Fennis <tim@isset.nl>
 */
class IntervalTransformer implements DataTransformerInterface
{
    public function transform($value)
    {
        return (string) $value;
    }

    public function reverseTransform($value)
    {
        if ('' === $value) {
            return null;
        }

        try {
            return Interval::createFromString($value);
        } catch (\InvalidArgumentException $e) {
            throw new TransformationFailedException($e->getMessage());
        }
    }
}
