<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\Domain\Repository;

use Doctrine\Common\Collections\Selectable;
use PhpOption\Option;

/**
 * Interface WalletOwnerRepository.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
interface WalletOwnerRepository extends Selectable
{
    /**
     * Returns an option baring the wallet owner if the wallet owner exists.
     *
     * @param mixed $identifier
     *
     * @return Option<WalletOwner>
     */
    public function optionallyFind($identifier): Option;
}
