<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\CommandBus\RenewSubscription;

use IssetBV\PaymentBundle\Domain\Subscription\SubscriptionIdentifier;

/**
 * @author Tim Fennis <tim@isset.nl>
 */
class CannotRenewSubscriptionException extends \DomainException
{
    public static function becauseTheSubscriptionCouldNotBeFound(SubscriptionIdentifier $identifier): CannotRenewSubscriptionException
    {
        return new self('Cannot renew subscription exception because the subscription with id ' . $identifier->asString() . ' could not be found');
    }

    public static function becauseTheSubscriptionDoesNotHaveAValidPayment(SubscriptionIdentifier $identifier): CannotRenewSubscriptionException
    {
        return new self('Cannot renew subscription because the subscription with id ' . $identifier->asString() . ' does not have a valid (repeatable) payment');
    }
}
