<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\Form\Type;

use IssetBV\PaymentBundle\Form\DataTransformer\MoneyTransformer;
use Money\Currencies\ISOCurrencies;
use Money\Formatter\DecimalMoneyFormatter;
use Money\Parser\DecimalMoneyParser;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

/**
 * @author Tim Fennis <tim@isset.nl>
 */
class MoneyType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $currencies = new ISOCurrencies();
        $builder->addViewTransformer(new MoneyTransformer(
            new DecimalMoneyFormatter($currencies),
            new DecimalMoneyParser($currencies),
            $options['force_currency']
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'force_currency' => null,
            'compound' => false,
        ]);
    }
}
