<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\ResponseHandler;

use IssetBV\PaymentBundle\Domain\ExecutablePayment;
use IssetBV\TalosBundle\Gateway\Response\Handler\ResponseHandler;
use IssetBV\TalosBundle\Gateway\Response\Response;
use IssetBV\TalosBundle\Gateway\Response\Status;
use IssetBV\TalosBundle\Mapper\Exception\MapperException;

/**
 * @author Tim Fennis <tim@isset.nl>
 */
class CreditCardPaymentResponseHandler implements ResponseHandler
{
    /**
     * @var ExecutablePayment
     */
    private $executablePayment;

    /**
     * CreditCardPaymentResponseHandler constructor.
     *
     * @param ExecutablePayment $executablePayment
     */
    public function __construct(ExecutablePayment $executablePayment)
    {
        $this->executablePayment = $executablePayment;
    }

    /**
     * @param Response $response
     *
     * @throws MapperException
     */
    public function handleResponse(Response $response)
    {
        $responseStatus = $response->findStatus()->getOrElse(null);

        if ($responseStatus instanceof Status) {
            $code = $responseStatus->getCode();

            if ('ValidationError' === $code || 'Failed' === $code) {
                throw MapperException::requestError($code, $responseStatus->getValue());
            }

            if ('UserRecoverableValidationError' === $code) {
                $this->executablePayment->setPaymentUrl($response->getRedirectUrl()->getOrThrow(MapperException::propertyNotFound('RedirectURL')));
            }
        }
    }
}
