<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\CommandBus\SynchronizeMutation;

use IssetBV\PaymentBundle\Domain\Mutation;

/**
 * Class SynchronizeMutationCommand.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
final class SynchronizeMutationCommand
{
    /**
     * @var string
     */
    private $mutationIdentifier;

    /**
     * SynchronizeMutationCommand constructor.
     *
     * Works with a mutationIdentifier. There is also a helper method to create this command from a Mutation instance.
     * If you specify the ID of an existing mutation that has not been registered in our local database one will be created.
     *
     * @param $mutationIdentifier
     */
    public function __construct(string $mutationIdentifier)
    {
        $this->mutationIdentifier = $mutationIdentifier;
    }

    /**
     * @param Mutation $mutation
     *
     * @return SynchronizeMutationCommand
     */
    public static function fromMutation(Mutation $mutation)
    {
        return new self($mutation->getIdentifier());
    }

    /**
     * @return string
     */
    public function getMutationIdentifier(): string
    {
        return $this->mutationIdentifier;
    }
}
