<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\CommandBus\CreateWallet;

/**
 * Class CreateWalletCommand.
 *
 *
 * @author Tim Fennis <tim@isset.nl>
 */
final class CreateWalletCommand
{
    /**
     * @var string
     */
    private $description;

    /**
     * @var string
     */
    private $walletOwnerIdentifier;

    /**
     * @var string
     */
    private $walletTypeIdentifier;

    /**
     * CreateWalletCommand constructor.
     *
     * @param string $walletOwnerIdentifier
     * @param string $walletTypeIdentifier
     * @param string $description
     */
    public function __construct(string $walletOwnerIdentifier, string $walletTypeIdentifier, string $description = '')
    {
        $this->walletOwnerIdentifier = $walletOwnerIdentifier;
        $this->walletTypeIdentifier = $walletTypeIdentifier;
        $this->description = $description;
    }

    /**
     * @return string
     */
    public function getDescription(): string
    {
        return $this->description;
    }

    /**
     * @return string
     */
    public function getWalletTypeIdentifier(): string
    {
        return $this->walletTypeIdentifier;
    }

    /**
     * @return string
     */
    public function getWalletOwnerIdentifier(): string
    {
        return $this->walletOwnerIdentifier;
    }
}
