<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\Domain;

/**
 * This interface describes an entity in the system that owns a wallet.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
interface WalletOwner
{
    /**
     * @return int
     */
    public function getId(): int;

    /**
     * @return string
     */
    public function getFullName(): string;

    /**
     * @return Wallet[]
     */
    public function getWallets();

    /**
     * @param Wallet $wallet
     */
    public function addWallet(Wallet $wallet);
}
