<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\CommandBus\SynchronizeWalletTypes;

use IssetBV\PaymentBundle\CommandBus\SynchronizeWalletTypes\SynchronizeWalletTypesCommand;
use IssetBV\TalosBundle\Gateway\ApiGateway;
use IssetBV\TalosBundle\Gateway\Request\ClientData;
use IssetBV\TalosBundle\Gateway\Request\Request;
use IssetBV\TalosBundle\Gateway\Request\Service;
use IssetBV\TalosBundle\Gateway\Shared\SingleField;
use IssetBV\TalosBundle\ResponseHandler\WalletTypeResponseHandler;

/**
 * Class SynchronizeWalletTypesHandler.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
class SynchronizeWalletTypesHandler
{
    /**
     * @var ApiGateway
     */
    private $gateway;

    /**
     * @var WalletTypeResponseHandler
     */
    private $walletTypeResponseHandler;

    /**
     * SynchronizeWalletTypesHandler constructor.
     *
     * @param ApiGateway $gateway
     * @param WalletTypeResponseHandler $walletTypeResponseHandler
     */
    public function __construct(ApiGateway $gateway, WalletTypeResponseHandler $walletTypeResponseHandler)
    {
        $this->gateway = $gateway;
        $this->walletTypeResponseHandler = $walletTypeResponseHandler;
    }

    /**
     * @param SynchronizeWalletTypesCommand $command
     */
    public function handle(SynchronizeWalletTypesCommand $command)
    {
        $request = new Request(ClientData::empty(), [
            new Service('WalletSystem', 'Status', [
                new SingleField('ObjectType', 'WalletType'),
            ]),
        ]);

        $request->addResponseHandler($this->walletTypeResponseHandler);

        $this->gateway->send([$request]);
    }
}
