<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\Domain\Subscription\Repository;

use Doctrine\Common\Collections\Selectable;
use IssetBV\PaymentBundle\Domain\Identifier\LocalPaymentIdentifier;
use IssetBV\PaymentBundle\Domain\Subscription\Subscription;
use IssetBV\PaymentBundle\Domain\Subscription\SubscriptionIdentifier;
use PhpOption\Option;

/**
 * @author Tim Fennis <tim@isset.nl>
 */
interface SubscriptionRepository extends Selectable
{
    /**
     * @return Subscription[]
     */
    public function findAll();

    public function findByOriginalPayment(LocalPaymentIdentifier $paymentIdentifier): Option;

    public function optionallyFind(SubscriptionIdentifier $identifier): Option;

    public function findByPayment(LocalPaymentIdentifier $paymentIdentifier): Option;
}
