<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\CommandBus\CreateMutation;

use Exception;

/**
 * Class CannotCreateMutationCommand.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
final class CannotCreateMutationCommand extends Exception
{
    public static function becauseTheSourceWalletWasNotGiven()
    {
        return new self('Cannot create mutation command because the source wallet was not given');
    }

    public static function becauseTheDestinationWalletWasNotGiven()
    {
        return new self('Cannot create mutation command because the destination wallet was not given');
    }

    public static function becauseTheAmountWasNotGiven()
    {
        return new self('Cannot create mutation command because the amount was not given');
    }
}
