<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Storage;

use Doctrine\Common\Persistence\ObjectManager;
use PhpOption\Option;

/**
 * Class Persister.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
class DoctrineEntityStore implements EntityStore
{
    /**
     * @var Option
     */
    private $objectManager;

    /**
     * Persister constructor.
     *
     * @param ObjectManager|null $objectManager
     */
    public function __construct(ObjectManager $objectManager = null)
    {
        $this->objectManager = Option::ensure($objectManager);
    }

    /**
     * @param object $entity
     */
    public function persist($entity)
    {
        $this->objectManager
            ->forAll(function (ObjectManager $objectManager) use ($entity) {
                $objectManager->persist($entity);
                $objectManager->flush();
            })
            ->getOrThrow(new StorageException(sprintf('Cannot store %s because the entity manager was not configured', get_class($entity))));
    }
}
