<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Money;

use Money\Currency;
use Money\Money;

/**
 * Class MoneyFactory.
 *
 * @author Tim Fennis <tim@isset.nl>
 *
 * @deprecated replace with decimal parser
 */
class MoneyFactory
{
    /**
     * @param string $amount
     * @param Currency $currency
     *
     * @return Money
     */
    public static function create(string $amount, Currency $currency = null): Money
    {
        $currency = $currency ?: new Currency('EUR');

        return (new Money(bcmul($amount, '10000', 0), $currency))->divide(100);
    }
}
