<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Gateway;

use IssetBV\Json\JsonThing;
use IssetBV\TalosBundle\Gateway\Exception\ResponseException;
use IssetBV\TalosBundle\Gateway\Request\Request as TalosApiRequest;
use IssetBV\TalosBundle\Gateway\Request\Service;

/**
 * Class ApiGateway.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
interface ApiGateway
{
    /**
     * @param Service $service
     *
     * @return JsonThing
     */
    public function loadServiceSpecification(Service $service);

    /**
     * @param TalosApiRequest[] $requests
     * @param string $channel
     *
     * @throws ResponseException
     */
    public function send(array $requests, string $channel = 'BatchFile');
}
