<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\Domain;

/**
 * Interface PaymentIssuer.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
interface PaymentIssuer
{
    /**
     * @return string
     */
    public function getDisplayName(): string;

    /**
     * Returns the code of this issuer to be used in the API.
     *
     * Example: ABNANL2A
     *
     * @return string
     */
    public function getCode(): string;

    /**
     * @return PaymentMethod
     */
    public function getPaymentMethod(): PaymentMethod;
}
