<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\CommandBus\SynchronizeAutoTopupProfiles;

use IssetBV\PaymentBundle\CommandBus\SynchronizeAutoTopupProfiles\SynchronizeAutoTopupProfilesCommand;
use IssetBV\TalosBundle\Gateway\ApiGateway;
use IssetBV\TalosBundle\Gateway\Request\ClientData;
use IssetBV\TalosBundle\Gateway\Request\Request;
use IssetBV\TalosBundle\Gateway\Request\Service;
use IssetBV\TalosBundle\Gateway\Shared\SingleField;
use IssetBV\TalosBundle\ResponseHandler\AutoTopupProfileResponseHandler;

/**
 * Class SynchronizeAutoTopupProfileHandler.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
class SynchronizeAutoTopupProfilesHandler
{
    /**
     * @var AutoTopupProfileResponseHandler
     */
    private $autoTopupProfileResponseHandler;

    /**
     * @var ApiGateway
     */
    private $apiGateway;

    /**
     * SynchronizeAutoTopupProfileHandler constructor.
     *
     * @param ApiGateway $apiGateway
     * @param AutoTopupProfileResponseHandler $autoTopupProfileResponseHandler
     */
    public function __construct(ApiGateway $apiGateway, AutoTopupProfileResponseHandler $autoTopupProfileResponseHandler)
    {
        $this->apiGateway = $apiGateway;
        $this->autoTopupProfileResponseHandler = $autoTopupProfileResponseHandler;
    }

    public function handle(SynchronizeAutoTopupProfilesCommand $command)
    {
        $request = new Request(ClientData::empty(), [
            new Service('WalletSystem', 'Status', [
                new SingleField('ObjectType', 'WalletAutoTopupProfile'),
            ]),
        ]);

        $request->addResponseHandler($this->autoTopupProfileResponseHandler);

        $this->apiGateway->send([$request]);
    }
}
