<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Cli\Renderer;

use IssetBV\PaymentBundle\Domain\ExecutablePayment;
use IssetBV\PaymentBundle\Domain\Payment;
use Money\MoneyFormatter;
use Symfony\Component\Console\Helper\Table;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * @author Tim Fennis <tim@isset.nl>
 */
class PaymentRenderer
{
    /**
     * @var MoneyFormatter
     */
    private $formatter;

    public function __construct(MoneyFormatter $formatter)
    {
        $this->formatter = $formatter;
    }

    public function render(Payment $payment, OutputInterface $output)
    {
        $table = new Table($output);
        $table->setHeaders(['Property', 'Value']);
        $table->addRow(['id', $payment->getId()]);
        $table->addRow(['amount', $payment->getAmount()->getAmount()]);

        if ($payment instanceof ExecutablePayment) {
            $table->addRow(['paymentUrl', $payment->getPaymentUrl()->getOrElse('---')]);
        }

        $table->addRow(['remoteStatus', $payment->getRemoteStatus()]);
        $table->addRow(['remoteIdentifier', $payment->getRemoteIdentifier()->getOrElse('---')]);

        $table->render();
    }
}
