<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Cli;

use Doctrine\Common\Collections\Criteria;
use IssetBV\PaymentBundle\CommandBus\CreateWallet\CreateWalletCommand as CreateWalletCommandCommand;
use IssetBV\PaymentBundle\Domain\Repository\WalletOwnerRepository;
use IssetBV\PaymentBundle\Domain\WalletOwner;
use League\Tactician\CommandBus;
use PhpOption\Option;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use function \Functional\each;

/**
 * Class CreateWalletCommand.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
class CreateWalletCommand extends Command
{
    /**
     * @var CommandBus
     */
    private $commandBus;

    /**
     * @var WalletOwnerRepository
     */
    private $walletOwnerRepository;

    /**
     * CreateWalletCommand constructor.
     *
     * @param CommandBus $commandBus
     * @param WalletOwnerRepository $walletOwnerRepository
     */
    public function __construct(CommandBus $commandBus, WalletOwnerRepository $walletOwnerRepository)
    {
        parent::__construct('talos:wallet:create');
        $this->commandBus = $commandBus;
        $this->walletOwnerRepository = $walletOwnerRepository;
    }

    public function loadAllWalletOwnerIds()
    {
        return $this->walletOwnerRepository
            ->matching(Criteria::create())
            ->filter(function (WalletOwner $user) {
                return count($user->getWallets()) === 0;
            })
            ->map(function (WalletOwner $walletOwner) {
                return $walletOwner->getId();
            });
    }

    protected function configure()
    {
        $this->addArgument('userId', InputArgument::OPTIONAL, 'The user ID');
    }

    /**
     * @param InputInterface $input
     * @param OutputInterface $output
     *
     * @return int|null|void
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $walletOwners = Option::ensure($input->getArgument('userId'))
            ->getOrCall([$this, 'loadAllWalletOwnerIds']);

        each($walletOwners, function (WalletOwner $user) {
            $this->createWallet($user->getId());
        });
    }

    /**
     * @param mixed $userId
     */
    protected function createWallet($userId)
    {
        $this->commandBus->handle(new CreateWalletCommandCommand(
            $userId,
            '6FA5120A2E5C4A7E82AC8AA81F2B63FF'
        ));
    }
}
