<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\Domain\Invoice;

/**
 * Class DefaultInvoiceNumber.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
class DefaultInvoiceNumber implements InvoiceNumber
{
    /**
     * @var string
     */
    private $number;

    public function __construct($number)
    {
        $this->number = $number;
    }

    /**
     * @return string
     */
    public function getAsString(): string
    {
        return $this->number;
    }
}
