<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\CommandBus\ConfigureAutoRenew;

use IssetBV\PaymentBundle\Domain\Identifier\LocalPaymentIdentifier;
use IssetBV\TalosBundle\Gateway\Request\ClientData;
use Money\Money;
use PhpOption\Option;

/**
 * Class ConfigureAutoRenewCommand.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
final class ConfigureAutoRenewCommand
{
    /**
     * @var ClientData|null
     */
    private $clientData;

    /**
     * @var int
     */
    private $cooldown;

    /**
     * @var string
     */
    private $walletIdentifier;

    /**
     * @var LocalPaymentIdentifier
     */
    private $paymentIdentifier;

    /**
     * @var Money
     */
    private $activationBalance;

    /**
     * ConfigureAutoRenewCommand constructor.
     *
     * @param string $walletIdentifier
     * @param LocalPaymentIdentifier $paymentIdentifier
     * @param Money $activationBalance
     * @param int $cooldown
     * @param ClientData|null $clientData
     */
    public function __construct(string $walletIdentifier, LocalPaymentIdentifier $paymentIdentifier, Money $activationBalance, int $cooldown, ClientData $clientData = null)
    {
        $this->walletIdentifier = $walletIdentifier;
        $this->paymentIdentifier = $paymentIdentifier;
        $this->clientData = $clientData;
        $this->activationBalance = $activationBalance;
        $this->cooldown = $cooldown;
    }

    /**
     * @return string
     */
    public function getWalletIdentifier(): string
    {
        return $this->walletIdentifier;
    }

    public function getPaymentIdentifier(): LocalPaymentIdentifier
    {
        return $this->paymentIdentifier;
    }

    /**
     * @return Money
     */
    public function getActivationBalance(): Money
    {
        return $this->activationBalance;
    }

    /**
     * @return int
     */
    public function getCooldown(): int
    {
        return $this->cooldown;
    }

    /**
     * @return Option<ClientData>
     */
    public function getClientData(): Option
    {
        return Option::ensure($this->clientData);
    }
}
