<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\Cli;

use IssetBV\PaymentBundle\Domain\Subscription\Repository\SubscriptionRepository;
use League\Tactician\CommandBus;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;

/**
 * @author Tim Fennis <tim@isset.nl>
 */
class ProcessSubscriptionsCommand extends Command
{
    /**
     * @var CommandBus
     */
    private $commandBus;

    /**
     * @var SymfonyStyle
     */
    private $console;

    /**
     * @var SubscriptionRepository
     */
    private $subscriptionRepository;

    public function __construct(
        CommandBus $commandBus,
        SubscriptionRepository $subscriptionRepository
    ) {
        parent::__construct('subscription:process');
        $this->commandBus = $commandBus;
        $this->subscriptionRepository = $subscriptionRepository;
    }

    public function configure()
    {
        // do nothing for now
    }

    public function execute(InputInterface $input, OutputInterface $output)
    {
        $this->console = new SymfonyStyle($input, $output);
        $this->console->title('Processing subscriptions');
        $this->console->listing(['Verify payment statuses', 'Create new payments', 'Denormalize subscription data']);

        $this->checkPaymentStatus();
    }

    private function checkPaymentStatus()
    {
    }
}
