<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Gateway\Request;

use JsonSerializable;
use PhpOption\None;
use PhpOption\Option;
use PhpOption\Some;
use stdClass;
use Symfony\Component\HttpFoundation\Request as SymfonyHttpRequest;

/**
 * Class ClientData.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
final class ClientData implements JsonSerializable
{
    /**
     * @var Option
     */
    private $ipAddress;

    /**
     * @var Option
     */
    private $userAgent;

    /**
     * ClientData constructor.
     *
     * @param $ipAddress
     * @param $userAgent
     */
    private function __construct($ipAddress, $userAgent)
    {
        $this->ipAddress = $ipAddress;
        $this->userAgent = $userAgent;
    }

    /**
     * @return stdClass
     */
    public function toSerializable()
    {
        return $this->jsonSerialize();
    }

    /**
     * @return stdClass
     */
    public function jsonSerialize()
    {
        $data = new stdClass();

        $this->userAgent->forAll(function ($userAgent) use ($data) {
            $data->UserAgent = $userAgent;
        });

        $this->ipAddress->forAll(function ($ipAddress) use ($data) {
            $data->IpAddress = $ipAddress;
        });

        return $data;
    }

    /**
     * @param SymfonyHttpRequest $request
     *
     * @return ClientData
     */
    public static function fromRequest(SymfonyHttpRequest $request)
    {
        return new self(
            Some::create($request->getClientIp()),
            Some::create($request->headers->get('User-Agent'))
        );
    }

    /**
     * @return ClientData
     */
    public static function empty()
    {
        return new self(
            None::create(),
            None::create()
        );
    }
}
