<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\ResponseHandler;

use IssetBV\TalosBundle\Gateway\Response\Handler\RequestErrorHandler;
use IssetBV\TalosBundle\Gateway\Response\Handler\ResponseHandler;
use IssetBV\TalosBundle\Gateway\Response\Response;
use Psr\Log\LoggerInterface;
use Psr\Log\NullLogger;

/**
 * Class LoggingResponseHandler.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
class LoggingResponseHandler implements ResponseHandler, RequestErrorHandler
{
    private $logger;

    public function __construct()
    {
        $this->logger = new NullLogger();
    }

    public function injectLogger(LoggerInterface $logger)
    {
        $this->logger = $logger;
    }

    public function onError(array $options)
    {
        $this->logger->info(json_encode($options['response'], JSON_PRETTY_PRINT));

        if (array_key_exists('exception', $options)) {
            $exception = $options['exception'];
            $exceptionClass = get_class($options['exception']);

            $this->logger->error(sprintf(
                'A %s exception has been thrown with message: %s',
                $exceptionClass, $exception->getMessage()
            ));

            //            throw $options['exception'];
        }
    }

    /**
     * @param Response $response
     */
    public function handleResponse(Response $response)
    {
        $this->logger->info(json_encode($response));
    }
}
