<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Domain;

/**
 * @author Tim Fennis <tim@isset.nl>
 */
interface TalosStatus
{
    const NONE = 'None';
    /** The payment has succeeded. */
    const SUCCESS = 'Success';
    /** The payment is being processed. */
    const PROCESSING = 'Processing';
    /** The payment is on hold, it will require attention by backoffice before it will continue processing.*/
    const ON_HOLD = 'OnHold';
    /** The payment is on hold pending aproval. The payment needs to be approved by authorized users. */
    const PENDING_APPROVAL = 'PendingApproval';
    /** The payment is waiting for the customer to perform an action before continuing processing. */
    const AWAITING_USER = 'AwaitingUser';
    /** The payment has failed. */
    const FAILED = 'Failed';
    /** The payment has been rejected by the processor. */
    const REJECTED = 'Rejected';
    /** The payment has been cancelled by the customer. */
    const CANCELED_BY_USER = 'CanceledByUser';
    /** The payment has been cancelled by the back office */
    const CANCELED_BY_BACK_OFFICE = 'CancelledByBackOffice';
    /** A technical error occured, preventing the payment from being completed. */
    const TECHNICAL_ERROR = 'TechnicalError';
    /** The payment has been expired */
    const EXPIRED = 'Expired';
}
