<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\Cli;

use IssetBV\PaymentBundle\CommandBus\CreateSubscription\CreateSubscriptionCommand as CreateSubscriptionCommandBusCommand;
use IssetBV\PaymentBundle\Domain\Payment\PaymentType;
use IssetBV\PaymentBundle\Domain\PaymentIssuer;
use IssetBV\PaymentBundle\Domain\Repository\PaymentIssuerRepository;
use IssetBV\PaymentBundle\Factory\InvoiceFactory;
use IssetBV\PaymentBundle\Factory\PaymentFactory;
use League\Tactician\CommandBus;
use Money\Currency;
use Money\Money;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;

/**
 * @author Tim Fennis <tim@isset.nl>
 */
class CreateSubscriptionCommand extends Command
{
    /**
     * @var CommandBus
     */
    private $commandBus;

    /**
     * @var PaymentIssuerRepository
     */
    private $issuerRepository;

    /**
     * @var PaymentFactory
     */
    private $paymentFactory;

    /**
     * @var InvoiceFactory
     */
    private $invoiceFactory;

    public function __construct(
        CommandBus $commandBus,
        PaymentFactory $paymentFactory,
        InvoiceFactory $invoiceFactory,
        PaymentIssuerRepository $issuerRepository
    ) {
        parent::__construct('subscription:create');
        $this->commandBus = $commandBus;
        $this->paymentFactory = $paymentFactory;
        $this->invoiceFactory = $invoiceFactory;
        $this->issuerRepository = $issuerRepository;
    }

    protected function configure()
    {
        // do nothing yet
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $console = new SymfonyStyle($input, $output);

        $subscriptionCost = new Money(299, new Currency('EUR'));

        /** @var PaymentIssuer $paymentIssuer */
        $paymentIssuer = $this->issuerRepository->findOneByCode('INGBNL2A')->getOrThrow(new \RuntimeException());

        $payment = $this->paymentFactory->createPayment(
            $this->invoiceFactory->createInvoice(),
            $subscriptionCost,
            $paymentIssuer->getPaymentMethod(),
            $paymentIssuer,
            PaymentType::createFirst()
        );

        $console->note('Payment created with ID: ' . $payment->getId()->asString());

        $this->commandBus->handle(new CreateSubscriptionCommandBusCommand($payment->getId()));

        $console->success('Subscription created');
    }
}
