<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Repository;

use Doctrine\ORM\EntityRepository;
use IssetBV\PaymentBundle\Domain\Repository\PaymentIssuerRepository;
use PhpOption\Option;

/**
 * Class DoctrinePaymentIssuerRepository.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
class DoctrinePaymentIssuerRepository extends EntityRepository implements PaymentIssuerRepository
{
    /**
     * @param string $customerAccountIssuer
     *
     * @return Option
     */
    public function findOneByCode(string $customerAccountIssuer): Option
    {
        return Option::ensure($this->findOneBy([
            'value' => $customerAccountIssuer,
        ]));
    }
}
