<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Gateway\Shared;

use IssetBV\Json\Exception\DecodeException;
use IssetBV\Json\JsonThing;

/**
 * Class GroupField.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
final class GroupField extends Field
{
    use FieldContainer;

    /**
     * FieldBase constructor.
     *
     * @param string $name
     * @param Field[] $value
     */
    public function __construct(string $name, array $value)
    {
        $this->name = $name;
        $this->setFields($value);
    }

    /**
     * @return array
     */
    public function toSerializable(): array
    {
        return [
            'Name' => $this->name,
            'Fields' => array_map(
                function (Field $field) {
                    return $field->toSerializable();
                }, $this->getFields()
            ),
        ];
    }

    /**
     * @param JsonThing $jsonThing
     *
     * @throws DecodeException
     *
     * @return Field
     */
    public static function fromJsonThing(JsonThing $jsonThing): Field
    {
        return new self($jsonThing['Name'], $jsonThing['Fields']->map(
            function (JsonThing $jsonThing) {
                return Field::fromJsonThing($jsonThing);
            }
        ));
    }
}
