<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\Factory;

use IssetBV\PaymentBundle\Domain\ExecutablePayment;
use IssetBV\PaymentBundle\Domain\Invoice\Invoice;
use IssetBV\PaymentBundle\Domain\Payment;
use IssetBV\PaymentBundle\Domain\PaymentIssuer;
use IssetBV\PaymentBundle\Domain\PaymentMethod;
use Money\Money;

/**
 * @author Tim Fennis <tim@isset.nl>
 */
interface PaymentFactory
{
    public function createPayment(Invoice $invoice, Money $money, PaymentMethod $paymentMethod, PaymentIssuer $issuer = null, string $recurrentType): Payment;

    public function createExecutablePayment(Invoice $invoice, Money $money, PaymentMethod $paymentMethod, PaymentIssuer $issuer = null, string $recurrentType): ExecutablePayment;
}
