<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Exception;

use Exception;

/**
 * Class CannotSynchronizeIssuersException.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
class CannotSynchronizeIssuersException extends Exception
{
    public function __construct($message = 'reason not specified', $code = 0, Exception $previous = null)
    {
        parent::__construct($message, $code, $previous);
    }

    public static function becauseTheIssuersCouldNotBeLoaded(): CannotSynchronizeIssuersException
    {
        return new self('because the issuers could not be loaded');
    }

    public static function becauseThePaymentMethodCouldNotBeFound(string $paymentMethodServiceName): CannotSynchronizeIssuersException
    {
        return new self('becuase the payment method could not be found (in the database). name: ' . $paymentMethodServiceName);
    }
}
