<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Domain;

use IssetBV\PaymentBundle\Domain\AutoRenewConfiguration;
use IssetBV\PaymentBundle\Domain\Payment;
use IssetBV\TalosBundle\Entity\TalosAutoTopupProfile;
use Money\Money;

/**
 * Class AutoTopupProfileWrapper.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
class AutoRenewConfigurationWrapper implements AutoRenewConfiguration
{
    /**
     * @var TalosAutoTopupProfile
     */
    private $autoTopupProfile;

    /**
     * @var Payment
     */
    private $payment;

    /**
     * @param Payment $profile
     * @param TalosAutoTopupProfile $autoTopupProfile
     */
    public function __construct(Payment $profile, TalosAutoTopupProfile $autoTopupProfile)
    {
        $this->payment = $profile;
        $this->autoTopupProfile = $autoTopupProfile;
    }

    /**
     * @return Money
     */
    public function getIncrementAmount(): Money
    {
        return $this->payment->getAmount();
    }

    /**
     * @return Money
     */
    public function getActivationBalance(): Money
    {
        return $this->autoTopupProfile->getActivationBalance();
    }
}
