<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Gateway\Request;

use IssetBV\Json\JsonThing;
use IssetBV\TalosBundle\Gateway\Shared\Field;
use IssetBV\TalosBundle\Gateway\Shared\FieldContainer;

/**
 * Class ServiceBase.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
final class Service
{
    use FieldContainer;

    /**
     * @var string
     */
    private $name;

    /**
     * @var string
     */
    private $action;

    /**
     * @var string
     */
    private $version;

    /**
     * ServiceBase constructor.
     *
     * @param string $name
     * @param string $action
     * @param array $fields
     */
    public function __construct(string $name, string $action, array $fields = [])
    {
        $this->name = $name;
        $this->action = $action;
        $this->version = '1';
        $this->setFields($fields);
    }

    /**
     * @param JsonThing $jsonThing
     *
     * @return Service
     */
    public static function fromJsonThing(JsonThing $jsonThing)
    {
        return new self(
            $jsonThing['Name'],
            $jsonThing['Action'],
//            $jsonThing['Version'],
            $jsonThing->hasProperty('Fields') ? $jsonThing['Fields']->map(
                function (JsonThing $jsonThing): Field {
                    return Field::fromJsonThing($jsonThing);
                }
            ) : []
        );
    }

    /**
     * @return array
     */
    public function toSerializable()
    {
        return [
            'Name' => $this->name,
            'Action' => $this->action,
            'Version' => $this->version,
            'Fields' => array_map(
                function (Field $fieldBase) {
                    return $fieldBase->toSerializable();
                }, $this->getFields()
            ),
        ];
    }
}
