<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\Domain;

use IssetBV\PaymentBundle\Domain\Identifier\LocalPaymentIdentifier;
use IssetBV\PaymentBundle\Domain\Invoice\Invoice;
use Money\Money;
use PhpOption\Option;

/**
 * Interface Payment.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
interface Payment extends RemoteObject
{
    /**
     * @return LocalPaymentIdentifier
     */
    public function getId(): LocalPaymentIdentifier;

    /**
     * @return Money
     */
    public function getAmount(): Money;

    /**
     * @return Invoice
     */
    public function getInvoice(): Invoice;

    /**
     * @return string
     */
    public function getReference(): string;

    /**
     * @return PaymentMethod
     */
    public function getPaymentMethod(): PaymentMethod;

    /**
     * @return Option
     */
    public function getPaymentIssuer(): Option;

    /**
     * Returns the recurrent type of this payment. Currently this is a string "First", "OneOff", "Recurring".
     *
     * @return string
     */
    public function getRecurrentType(): string;

    /**
     * Returns true if this payment is usable for auto topup profiles.
     *
     * @return bool
     */
    public function isUsableForAutoTopup(): bool;
}
