<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\CommandBus\DenormalizeSubscriptionStatus;

use Assert\Assertion;
use IssetBV\PaymentBundle\Domain\Subscription\SubscriptionIdentifier;
use IssetBV\PaymentBundle\Domain\Subscription\SubscriptionStatus;
use Symfony\Component\EventDispatcher\Event;

/**
 * @author Tim Fennis <tim@isset.nl>
 */
class SubscriptionStatusChangedEvent extends Event
{
    const NAME = 'subscription.status.changed';

    /**
     * @var SubscriptionIdentifier
     */
    private $subscriptionIdentifier;

    /**
     * @var SubscriptionStatus
     */
    private $newSubscriptionStatus;

    /**
     * @var SubscriptionStatus
     */
    private $originalSubscriptionStatus;

    public function __construct(SubscriptionIdentifier $subscriptionIdentifier, SubscriptionStatus $originalSubscriptionStatus, SubscriptionStatus $newSubscriptionStatus)
    {
        Assertion::false($originalSubscriptionStatus->equals($newSubscriptionStatus), 'Failed asserting that originalSubscriptionStatus argument differs from newSubscriptionStatus argument');

        $this->subscriptionIdentifier = $subscriptionIdentifier;
        $this->originalSubscriptionStatus = $originalSubscriptionStatus;
        $this->newSubscriptionStatus = $newSubscriptionStatus;
    }

    public function getSubscriptionIdentifier(): SubscriptionIdentifier
    {
        return $this->subscriptionIdentifier;
    }

    public function getNewSubscriptionStatus(): SubscriptionStatus
    {
        return $this->newSubscriptionStatus;
    }

    public function getOriginalSubscriptionStatus(): SubscriptionStatus
    {
        return $this->originalSubscriptionStatus;
    }

    public static function name()
    {
        return self::NAME;
    }
}
