<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\Entity;

use Assert\Assertion;
use DateInterval;
use Doctrine\ORM\Mapping as ORM;
use PhpOption\None;
use PhpOption\Option;

/**
 * @author Tim Fennis <tim@isset.nl>
 *
 * @ORM\Embeddable()
 */
class Interval
{
    const FULL = '%y years + %m months + %d days + %h hours + %i minutes + %s seconds';
    
    /**
     * @var string
     * @ORM\Column(name="value", type="string")
     */
    private $value;

    private function __construct($dateInterval)
    {
        $this->value = $dateInterval;
        Assertion::false($this->isZero(), "Cannot create Interval because $dateInterval evaluates to zero");
    }

    public static function createFromString(string $dateIntervalString)
    {
        try {
            $interval = new DateInterval($dateIntervalString);
        } catch (\Exception $e) {
            $interval = DateInterval::createFromDateString($dateIntervalString);
        }

        return self::createFromDateInterval($interval);
    }

    public static function createFromDateInterval(DateInterval $dateInterval)
    {
        return new self(self::dateIntervalToString($dateInterval));
    }

    public function getDateInterval(): Option
    {
        return $this->isZero()
            ? None::create()
            : Option::fromValue(DateInterval::createFromDateString($this->value));
    }

    public function isZero()
    {
        $interval = DateInterval::createFromDateString($this->value);

        return $interval->y === 0 && $interval->m === 0 && $interval->d === 0 && $interval->h === 0 && $interval->i === 0 && $interval->s === 0;
    }

    private static function dateIntervalToString(DateInterval $dateInterval)
    {
        return $dateInterval->format('%y years + %m months + %d days + %h hours + %i minutes + %s seconds');
    }
}
