<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\Domain;

use DateTime;
use PhpOption\Option;
use Money\Money;

/**
 * Class Mutation.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
interface Mutation
{
    /**
     * @return string
     */
    public function getIdentifier(): string;

    /**
     * @return DateTime
     */
    public function getDateTime();

    /**
     * @return Option<Mutation>
     */
    public function getPairedMutation(): Option;

    /**
     * @return string
     */
    public function getDescription(): string;

    /**
     * @return Option<Wallet>
     */
    public function getWallet(): Option;

    /**
     * @return Money
     */
    public function getAmount(): Money;

    /**
     * @return Option<Payment>
     */
    public function getPayment(): Option;
}
