<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\CommandBus\CreateSubscription;

use DateInterval;
use DateTime;
use IssetBV\PaymentBundle\Domain\Identifier\LocalPaymentIdentifier;

/**
 * @author Tim Fennis <tim@isset.nl>
 */
class CreateSubscriptionCommand
{
    /**
     * @var LocalPaymentIdentifier
     */
    private $paymentIdentifier;

    public function __construct(LocalPaymentIdentifier $paymentIdentifier)
    {
        $this->paymentIdentifier = $paymentIdentifier;
    }

    public function getOriginalPaymentIdentifier(): LocalPaymentIdentifier
    {
        return $this->paymentIdentifier;
    }

    public function getSubscriptionInterval(): DateInterval
    {
        return DateInterval::createFromDateString('1 month');
    }

    public function getSubscriptionStartDate(): DateTime
    {
        return new DateTime();
    }
}
