<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Storage;

/**
 * Class Persister.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
interface EntityStore
{
    /**
     * Persist the given entity in the underlying storage layer.
     *
     * @throws StorageException if the underlying storage layer was not configured
     *
     * @param $entity
     */
    public function persist($entity);

}
