<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\CommandBus\CreateAutoTopupProfile;

use IssetBV\PaymentBundle\CommandBus\CreateAutoTopupProfile\CreateAutoTopupProfileCommand;
use IssetBV\TalosBundle\Gateway\ApiGateway;
use IssetBV\TalosBundle\Gateway\Request\ClientData;
use IssetBV\TalosBundle\Gateway\Request\Request;
use IssetBV\TalosBundle\Gateway\Request\Service;
use IssetBV\TalosBundle\Gateway\Shared\GroupField;
use IssetBV\TalosBundle\Gateway\Shared\SingleField;
use IssetBV\TalosBundle\ResponseHandler\AutoTopupProfileResponseHandler;
use Money\Formatter\DecimalMoneyFormatter;
use Money\Money;

/**
 * Class SynchronizeAutoTopupProfileHandler.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
class CreateAutoTopupProfileHandler
{
    /**
     * @var ApiGateway
     */
    private $apiGateway;

    /**
     * @var \IssetBV\TalosBundle\ResponseHandler\AutoTopupProfileResponseHandler
     */
    private $autoTopupProfileResponseHandler;

    /**
     * @var DecimalMoneyFormatter
     */
    private $decimalFormatter;

    /**
     * CreateAutoTopupProfileHandler constructor.
     *
     * @param ApiGateway $apiGateway
     * @param \IssetBV\TalosBundle\ResponseHandler\AutoTopupProfileResponseHandler $autoTopupProfileResponseHandler
     * @param DecimalMoneyFormatter $decimalFormatter
     */
    public function __construct(
        ApiGateway $apiGateway,
        AutoTopupProfileResponseHandler $autoTopupProfileResponseHandler,
        DecimalMoneyFormatter $decimalFormatter
    ) {
        $this->apiGateway = $apiGateway;
        $this->autoTopupProfileResponseHandler = $autoTopupProfileResponseHandler;
        $this->decimalFormatter = $decimalFormatter;
    }

    /**
     * @param CreateAutoTopupProfileCommand $command
     */
    public function handle(CreateAutoTopupProfileCommand $command)
    {
        $topupProfileConfiguration = [
//            new SingleField('ObjectIdentifier', 'Friday'),
            new SingleField('WalletCode', 'Friday'), //@todo wat is deze
        ];

        $command->getCooldown()->forAll(
            function (int $cooldown) use (&$topupProfileConfiguration) {
                $topupProfileConfiguration[] = new SingleField('Cooldown', (string) $cooldown);
            }
        );
        $command->getLimitPeriod()->forAll(
            function (int $limitPeriod) use (&$topupProfileConfiguration) {
                $topupProfileConfiguration[] = new SingleField('LimitPeriod', (string) $limitPeriod);
            }
        );
        $command->getLimitAmount()->forAll(
            function (Money $limitAmount) use (&$topupProfileConfiguration) {
                $topupProfileConfiguration[] = new SingleField('LimitAmount', $this->decimalFormatter->format($limitAmount));
            }
        );
        $command->getActivationBalance()->forAll(
            function (Money $activationBalance) use (&$topupProfileConfiguration) {
                $topupProfileConfiguration[] = new SingleField('ActivationBalance', $this->decimalFormatter->format($activationBalance));
            }
        );

        $request = new Request(ClientData::empty(), [
            new Service('WalletSystem', 'Configure', [
                new GroupField('AutoTopupProfile', $topupProfileConfiguration),
            ]),
        ]);

        $request->addResponseHandler($this->autoTopupProfileResponseHandler);

        $this->apiGateway->send([$request]);
    }
}
