<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Cli;

use IssetBV\PaymentBundle\Domain\PaymentIssuer;
use IssetBV\PaymentBundle\Domain\Repository\PaymentIssuerRepository;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;
use function Functional\map;

/**
 * @author Tim Fennis <tim@isset.nl>
 */
class ShowIssuersCommand extends Command
{
    /**
     * @var PaymentIssuerRepository
     */
    private $paymentIssuerRepository;

    public function __construct(PaymentIssuerRepository $paymentIssuerRepository)
    {
        parent::__construct('talos:issuers:show');
        $this->paymentIssuerRepository = $paymentIssuerRepository;
    }

    protected function configure()
    {
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $console = new SymfonyStyle($input, $output);
        $console->title('Issuers');
        $console->table(['Code', 'Name', 'Method Name'],
            map($this->paymentIssuerRepository->findAll(), function (PaymentIssuer $paymentIssuer) {
                return [
                    $paymentIssuer->getCode(),
                    $paymentIssuer->getDisplayName(),
                    $paymentIssuer->getPaymentMethod()->getDisplayName()
                ];
            })
        );
    }
}
