<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\Repository;

use Doctrine\Common\Collections\Collection;
use Doctrine\Common\Collections\Criteria;
use Doctrine\ORM\EntityRepository;
use IssetBV\PaymentBundle\Domain\Subscription\Repository\SubscriptionRepository;
use IssetBV\PaymentBundle\Domain\Subscription\Subscription;
use IssetBV\PaymentBundle\Domain\Subscription\SubscriptionIdentifier;
use PhpOption\Option;

/**
 * @author Tim Fennis <tim@isset.nl>
 */
class DoctrineSubscriptionRepository extends EntityRepository implements SubscriptionRepository
{
    /**
     * @return Collection|Subscription[]
     */
    public function findAll()
    {
        return $this->matching(Criteria::create());
    }

    /**
     * @param SubscriptionIdentifier $identifier
     *
     * @return Option
     */
    public function optionallyFind(SubscriptionIdentifier $identifier): Option
    {
        return Option::ensure(parent::find($identifier->asString()));
    }
}
