<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\Entity;

use DateTime;
use Doctrine\ORM\Mapping as ORM;
use IssetBV\PaymentBundle\Domain\Payment;
use IssetBV\PaymentBundle\Domain\Subscription\Subscription;

/**
 * @author Tim Fennis <tim@isset.nl>
 * @ORM\Entity()
 * @ORM\Table(name="subscriptions_payments")
 */
class SubscriptionPayment
{
    /**
     * @var Subscription
     * @ORM\Id()
     * @ORM\ManyToOne(targetEntity="IssetBV\PaymentBundle\Domain\Subscription\Subscription")
     */
    private $subscription;

    /**
     * @var Payment
     * @ORM\Id()
     * @ORM\ManyToOne(targetEntity="IssetBV\PaymentBundle\Domain\Payment")
     */
    private $payment;

    /**
     * @var DateTime
     * @ORM\Column(name="date_time", type="datetime", nullable=false)
     */
    private $dateTime;

    public function __construct(Subscription $subscription, Payment $payment)
    {
        $this->subscription = $subscription;
        $this->payment = $payment;
        $this->dateTime = new DateTime();
    }

    /**
     * @return DateTime
     */
    public function getDateTime(): DateTime
    {
        return $this->dateTime;
    }

    /**
     * @return Subscription
     */
    public function getSubscription(): Subscription
    {
        return $this->subscription;
    }

    /**
     * @return Payment
     */
    public function getPayment(): Payment
    {
        return $this->payment;
    }

    /**
     * @return bool
     */
    public function isActive(): bool
    {
        $endOfThisTerm = clone $this->dateTime;
        $endOfThisTerm->add($this->getSubscription()->getPaymentInterval());

        return (new DateTime())->getTimestamp() < $endOfThisTerm->getTimestamp();
    }
}
