<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\Domain;

use PhpOption\Option;
use Money\Money;

/**
 * Interface Wallet.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
interface Wallet
{
    /**
     * @return Money
     */
    public function getBalance(): Money;

    /**
     * @return string
     */
    public function getIdentifier(): string;

    /**
     * Will return something compatible with a Mutation array.
     *
     * @return Mutation[]
     */
    public function getMutations();

    /**
     * Not all wallets have an owner.
     *
     * @return Option<WalletOwner>
     */
    public function getOwner(): Option;

    /**
     * @return string
     */
    public function getReference();

    /**
     * @return Option<AutoRenewConfiguration>
     */
    public function getAutoRenewConfiguration(): Option;

    /**
     * @return WalletType
     */
    public function getType(): WalletType;
}
