<?php

namespace IssetBV\PaymentBundle\Domain\Subscription;

use DateInterval;
use PhpOption\Option;

/**
 * Interface Subscription.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
interface Subscription
{
    public function getId(): SubscriptionIdentifier;

    public function cancel(): bool;

    public function getDateValidUntil(): Option;

    public function getStartDate(): Option;

    public function getDateCanceled(): Option;

    public function getStatus(): SubscriptionStatus;

    public function getPaymentInterval(): DateInterval;
}