<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\CommandBus\ExecutePayment;

use IssetBV\PaymentBundle\Domain\ExecutablePayment;
use IssetBV\PaymentBundle\Domain\Identifier\LocalPaymentIdentifier;
use IssetBV\TalosBundle\Gateway\Request\ClientData;
use League\Uri\Schemes\Http;
use PhpOption\Option;

/**
 * Class CreatePaymentCommand.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
final class ExecutePaymentCommand
{
    /**
     * @var ClientData
     */
    private $clientData;

    /**
     * @var LocalPaymentIdentifier
     */
    private $paymentId;

    /**
     * @var string
     */
    private $returnUrl;

    /**
     * CreatePaymentCommand constructor.
     *
     * @param LocalPaymentIdentifier $paymentId
     * @param string $returnUrl
     * @param ClientData $clientData
     */
    public function __construct(LocalPaymentIdentifier $paymentId, $returnUrl, ClientData $clientData = null)
    {
        $this->paymentId = $paymentId;
        $this->clientData = $clientData;

        Http::createFromString($returnUrl); //@throws some shit

        $this->returnUrl = $returnUrl;
    }

    /**
     * @return LocalPaymentIdentifier
     */
    public function getPaymentId(): LocalPaymentIdentifier
    {
        return $this->paymentId;
    }

    /**
     * @return string
     */
    public function getReturnUrl(): string
    {
        return $this->returnUrl;
    }

    /**
     * @return Option
     */
    public function getClientData(): Option
    {
        return Option::ensure($this->clientData);
    }
}
