<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\CommandBus\ExecutePayment;

use Exception;
use IssetBV\PaymentBundle\Domain\Identifier\LocalPaymentIdentifier;

/**
 * @author Tim Fennis <tim@isset.nl>
 */
final class CannotExecutePaymentException extends Exception
{
    public static function becauseNoIssuerWasSet($paymentIdentifier = 'unknown'): CannotExecutePaymentException
    {
        return new self("Unable to create service request for ideal payment (id: $paymentIdentifier) because no payment issuer (bank) was set in the payment");
    }

    public static function becauseTheReturnUrlWasNotSet($paymentIdentifier = 'unknown'): CannotExecutePaymentException
    {
        return new self("Unable to execute payment (id: $paymentIdentifier) because the return URL was not set in the payment");
    }

    public static function becauseThePaymentDoesNotExist(LocalPaymentIdentifier $paymentId): CannotExecutePaymentException
    {
        return new self('Unable to execute payment because no payment with id ' . $paymentId->asString() . ' could be found');
    }
}
