<?php

declare(strict_types = 1);

namespace IssetBV\PaymentBundle\Cli;

use DateTime;
use IssetBV\PaymentBundle\Domain\Subscription\Repository\SubscriptionRepository;
use IssetBV\PaymentBundle\Domain\Subscription\Subscription;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\ArrayInput;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\NullOutput;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\OutputStyle;
use Symfony\Component\Console\Style\SymfonyStyle;
use function Functional\map;

/**
 * @author Tim Fennis <tim@isset.nl>
 */
class ShowAllSubscriptionsCommand extends Command
{
    /**
     * @var OutputStyle
     */
    private $cli;

    /**
     * @var SubscriptionRepository
     */
    private $subscriptionRepository;

    public function __construct(SubscriptionRepository $subscriptionRepository)
    {
        parent::__construct('subscription:show');
        $this->cli = new SymfonyStyle(new ArrayInput([]), new NullOutput());
        $this->subscriptionRepository = $subscriptionRepository;
    }

    public function configure()
    {
    }

    public function execute(InputInterface $input, OutputInterface $output)
    {
        $this->cli = new SymfonyStyle($input, $output);
        $this->cli->title('Subscriptions');

        $subscriptions = $this->subscriptionRepository->findAll();

        $this->cli->table(
            ['id', 'status code', 'start date', 'date valid until', 'date canceled'],
            map($subscriptions, function (Subscription $subscription) {
                return [
                    $subscription->getId()->asString(),
                    (string) $subscription->getStatus(),
                    $subscription->getStartDate()
                        ->map([$this, 'formatDateTime'])
                        ->getOrElse('-'),
                    $subscription->getDateValidUntil()
                        ->map([$this, 'formatDateTime'])
                        ->getOrElse('-'),
                    $subscription->getDateCanceled()
                        ->map([$this, 'formatDateTime'])
                        ->getOrElse('-'),
                ];
            })
        );
    }
    public function formatDateTime(DateTime $dateTime) {
        return $dateTime->format(DateTime::W3C);
    }
}

