<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Repository;

use Doctrine\Common\Collections\Collection;
use Doctrine\Common\Collections\Criteria;
use Doctrine\Common\Collections\Selectable;
use Doctrine\ORM\EntityRepository;
use IssetBV\PaymentBundle\Domain\PaymentIssuer;
use IssetBV\PaymentBundle\Domain\PaymentMethod;
use IssetBV\PaymentBundle\Domain\Repository\PaymentIssuerRepository;
use PhpOption\Option;

/**
 * Class DoctrinePaymentIssuerRepository.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
class DoctrinePaymentIssuerRepository extends EntityRepository implements PaymentIssuerRepository
{
    /**
     * @param string $customerAccountIssuer
     *
     * @return Option
     */
    public function findOneByCode(string $customerAccountIssuer): Option
    {
        return Option::ensure($this->findOneBy([
            'value' => $customerAccountIssuer,
        ]));
    }

    /**
     * @param PaymentMethod $paymentMethod
     *
     * @return Collection|Selectable|PaymentIssuer[]
     */
    public function findByPaymentMethod(PaymentMethod $paymentMethod)
    {
        $criteria = Criteria::create();
        $criteria->where(Criteria::expr()->eq('paymentMethod', $paymentMethod));

        return $this->matching($criteria);
    }
}
